/* AMX Mod X script.
*
*   Ninja Rope (amx_ejl_spacedude_ninjarope.sma)
*   Copyright (C) 2003-2004  SpaceDude / Eric Lidman / jtp10181
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either version 2
*   of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*   In addition, as a special exception, the author gives permission to
*   link the code of this program with the Half-Life Game Engine ("HL
*   Engine") and Modified Game Libraries ("MODs") developed by Valve,
*   L.L.C ("Valve"). You must obey the GNU General Public License in all
*   respects for all of the code used other than the HL Engine and MODs
*   from Valve. If you modify this file, you may extend this exception
*   to your version of the file, but you are not obligated to do so. If
*   you do not wish to do so, delete this exception statement from your
*   version.
*
****************************************************************************
*
*   Version 1.1.1 - Date: 10/16/2004
*
*   Original by SpaceDude and Eric Lidman aka "Ludwig van" <ejlmozart@hotmail.com>
*   Homepage: http://lidmanmusic.com/cs/plugins.html
*
*   Upgraded to STEAM and ported to AMXx by: jtp10181 <jtp@jtpage.net>
*   Homepage: http://www.jtpage.net
*
****************************************************************************
*
*  Formely known as Grappling Hook, I [SpaceDude] changed the name to Ninja 
*  Rope to avoid confusion with the hook metamod plugin. Also the plugin now 
*  acts in exactly the same way as the ninja rope from the game worms. Its 
*  based on real world physics, modelled as a point mass on the end of a rod.
*  
*  This plugin is similar to the Hook Grab plugin but there are few distinct 
*  differences. Players are not given a "boost" when the rope is attached. The 
*  rope has different physics and acts more like a rope, in fact it is near 
*  identical to the operation of the rope from the orginal 2D Worms game. 
*  There is a different sprite used for the rope and it LOOKS like a rope 
*  instead of a giant beam.
*  
*
*  Admin Commands:
*
*  amx_rope		- toggles rope on and off. Also if cvar mentioned
*                         below is set to 1, it also activates/deactivates
*                         plugin "out_of_bounds.amx" if you are using it
*                         so that bounds limits are off when rope is on and
*                         vice versa
*  amx_rope_count       - <# of ropes allowed per player round>
*
*
*  Client Command:
*
*    +rope - bind a key to +rope like this: bind <key> +rope, once you
*            have done that look in the direction where you want to fire
*            the hook and press the button. You can shorten the rope by
*            holding down the jump key, and make it longer by holding the
*            crouch key. Also you can move around with the regular move
*            keys (+forward, +back, +moveleft, +moveright) to release the
*            rope just let go of the button.
*
*    rope_toggle - has the same effect as +rope, except that you press it
*                  once to fire it and once again to release.
*
*    say /rope		- show window with info about use of rope
*
*  CVARs: Paste the following into your amxx.cfg to change defaults.
*		You must uncomment cvar lines for them to take effect
*
****************************************************************************
*  CVAR CONFIG BEGIN
****************************************************************************

// ******************  Ninja Rope Settings  ******************

//0 to disable ninjarope, 1 to enable ninjarope
//sv_ninjarope 1

//If you are running my "out_of_bounds" plugin you may want it disabled when
//you have the rope fully enabled. If you want this plugin to leave
//"out_of_bounds" alone, then set this cvar to 0.
//amx_rb_pl_kill 1

//Default is 0, to enforce a 15 second delay on roping
//at round start so as to prevent spawn massacres set to 1.
//amx_rope_spawndelay 0

//Set to 1 to not allow vip to use rope. Set cvar to 0 to allow free vip roping
//amx_rope_no_vip 1

//This is number of times a player may use the rope each round.
//Default is 100. I would suggest setting to 2 or 3 per round to
//encourage strategic usage of the rope rather than just having it be total craziness.
//amx_ropes_round 100

//Switch to report number of ropes remaining in a round to a player if
//that number drops to 10 or less. By default its on 1, set to 0 to turn off this report.
//amx_rep_rcount 1

//1 is a rope like looking rope with no team colors,
//0 is for the original look with red and blue beams
//amx_ropetype 1

****************************************************************************
*  CVAR CONFIG END
****************************************************************************
*
*                 ******** Engine Module REQUIRED ********
*                   ******** FUN Module REQUIRED ********
*
*  Changelog:
*
*  v1.1.1 - JTP10181 - 10/16/04
*	- Updated for AMXModX 0.20
*
*  v1.1 - JTP10181 - 07/10/04
*	- Made it so the rope cannot be used before the freezetime has ended
*	- Rearranged a lot of code and removed some useless events
*	- Removed all voting code, use amx_customvotes instead
*
*  v1.01 - JTP10181 - 06/18/04
*	- Converted MOTD boxes to work with steam and possibly with WON still (untested)
*	- Fixed all authid variables to be 32 chars to STEAMIDs are handled properly
*	- Ported functions to AMXX and replaced AMX tags with AMXX
*	- Fixed logging to admin log for AMXx
*
*  Below v1.01 was maintained by Eric Lidman / SpaceDude
*
**************************************************************************/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>

new ob_pl1,ob_pl2

new round_delay
new IsVip[33]
new RopeCount[33]
new Float:RpDelay[33]

#define HOLD_T 8.0
#define ROPE_DELAY 0.5
#define TE_BEAMENTPOINT 1
#define TE_KILLBEAM 99
#define DELTA_T 0.1		// seconds
#define BEAMLIFE 100		// deciseconds
#define MOVEACCELERATION 150	// units per second^2
#define REELSPEED 200		// units per second

new hooklocation[33][3]
new hooklength[33]
new bool:hooked[33]
new bool:roundfreeze
new bool:mapbounds_checked
new Float:beamcreated[33]

new global_gravity
new beam
new s_rope

public hooktask(parm[]) {
	new id = parm[0]
	new user_origin[3], user_look[3], user_direction[3], move_direction[3]
	new A[3], D[3], buttonadjust[3]
	new acceleration, velocity_TA, desired_velocity_TA
	new velocity[3], null[3]
	new Float:tmpVector[3]

	if (!is_user_alive(id)) {
		release(id)
		return
	}

	if (beamcreated[id] + BEAMLIFE/10 <= get_gametime()) {
		beamentpoint(id)
	}

	null[0] = 0
	null[1] = 0
	null[2] = 0

	get_user_origin(id, user_origin)
	get_user_origin(id, user_look,2)
	
	entity_get_vector(id, EV_VEC_velocity, tmpVector)
	FVecIVec(tmpVector, velocity)

	buttonadjust[0]=0
	buttonadjust[1]=0

	if (get_user_button(id)&IN_FORWARD) {
		buttonadjust[0]+=1
	}
	if (get_user_button(id)&IN_BACK) {
		buttonadjust[0]-=1
	}
	if (get_user_button(id)&IN_MOVERIGHT) {
		buttonadjust[1]+=1
	}
	if (get_user_button(id)&IN_MOVELEFT) {
		buttonadjust[1]-=1
	}
	if (get_user_button(id)&IN_JUMP) {
		buttonadjust[2]+=1
	}
	if (get_user_button(id)&IN_DUCK) {
		buttonadjust[2]-=1
	}

	if (buttonadjust[0] || buttonadjust[1]) {
		user_direction[0] = user_look[0] - user_origin[0]
		user_direction[1] = user_look[1] - user_origin[1]

		move_direction[0] = buttonadjust[0]*user_direction[0] + user_direction[1]*buttonadjust[1]
		move_direction[1] = buttonadjust[0]*user_direction[1] - user_direction[0]*buttonadjust[1]
		move_direction[2] = 0

		velocity[0] += floatround(move_direction[0] * MOVEACCELERATION * DELTA_T / get_distance(null,move_direction))
		velocity[1] += floatround(move_direction[1] * MOVEACCELERATION * DELTA_T / get_distance(null,move_direction))
	}
	if (buttonadjust[2]) {
		hooklength[id] -= floatround(buttonadjust[2] * REELSPEED * DELTA_T)
	}
	if (hooklength[id] < 100) {
		(hooklength[id]) = 100
	}

	A[0] = hooklocation[id][0] - user_origin[0]
	A[1] = hooklocation[id][1] - user_origin[1]
	A[2] = hooklocation[id][2] - user_origin[2]

	D[0] = A[0]*A[2] / get_distance(null,A)
	D[1] = A[1]*A[2] / get_distance(null,A)
	D[2] = -(A[1]*A[1] + A[0]*A[0]) / get_distance(null,A)

	new aDistance = get_distance(null,D) ? get_distance(null,D) : 1
	acceleration = - global_gravity * D[2] / aDistance

	velocity_TA = (velocity[0] * A[0] + velocity[1] * A[1] + velocity[2] * A[2]) / get_distance(null,A)
	desired_velocity_TA = (get_distance(user_origin,hooklocation[id]) - hooklength[id] /*- 10*/) * 4

	if (get_distance(null,D)>10) {
		velocity[0] += floatround((acceleration * DELTA_T * D[0]) / get_distance(null,D))
		velocity[1] += floatround((acceleration * DELTA_T * D[1]) / get_distance(null,D))
		velocity[2] += floatround((acceleration * DELTA_T * D[2]) / get_distance(null,D))
	}

	velocity[0] += ((desired_velocity_TA - velocity_TA) * A[0]) / get_distance(null,A)
	velocity[1] += ((desired_velocity_TA - velocity_TA) * A[1]) / get_distance(null,A)
	velocity[2] += ((desired_velocity_TA - velocity_TA) * A[2]) / get_distance(null,A)

	IVecFVec(velocity, tmpVector)
	entity_set_vector(id, EV_VEC_velocity, tmpVector)
}

public hook_on(id){
	if (!get_cvar_num("sv_ninjarope") || hooked[id] || !is_user_alive(id) || roundfreeze)
		return PLUGIN_HANDLED
		
	new ropes_round_cvar
	if(IsVip[id]){
		client_print(id,print_chat, "[AMXX] Roping by the VIP is prohibited.")
		return PLUGIN_HANDLED
	}
	else if(round_delay == 1){
		client_print(id,print_chat, "[AMXX] Roping during the first 15 seconds of a round is prohibited.")
		return PLUGIN_HANDLED
	}
	if(RpDelay[id] > get_gametime() - ROPE_DELAY)
		return PLUGIN_HANDLED

	RpDelay[id] = get_gametime()
	RopeCount[id] +=1
	ropes_round_cvar = get_cvar_num("amx_ropes_round")
	if(RopeCount[id] > ropes_round_cvar){
		client_print(id,print_chat, "[AMXX] You are all out of rope. Wait until next round.")
		return PLUGIN_HANDLED
	}
	else {
		if( (get_cvar_num("amx_rep_rcount") == 1) && (ropes_round_cvar - RopeCount[id] < 10) ) {
			if(ropes_round_cvar-RopeCount[id] == 0)
				client_print(id,print_chat, "[AMXX] That was your last rope for this round.")
			else
				client_print(id,print_chat, "[AMXX] You have %d ropes left, use them wisely.",ropes_round_cvar - RopeCount[id])
		}
	}
	attach(id)
	
	return PLUGIN_HANDLED
}

public hook_off(id) {
	if (get_cvar_num("sv_ninjarope") && hooked[id])
		release(id)

	return PLUGIN_HANDLED
}

public rope_toggle(id) {
	if (get_cvar_num("sv_ninjarope") && !hooked[id] && is_user_alive(id)){
		new ropes_round_cvar
		if(IsVip[id]){
			client_print(id,print_chat, "[AMXX] Roping by the VIP is prohibited.")
			return PLUGIN_HANDLED
		}
		else if(round_delay == 1){
			client_print(id,print_chat, "[AMXX] Roping during the first 15 seconds of a round is prohibited.")
			return PLUGIN_HANDLED
		}
		if(RpDelay[id] > get_gametime() - ROPE_DELAY)
			return PLUGIN_HANDLED
		RpDelay[id] = get_gametime()
		RopeCount[id] +=1
		ropes_round_cvar = get_cvar_num("amx_ropes_round")
		if(RopeCount[id] > ropes_round_cvar){
			client_print(id,print_chat, "[AMXX] You are all out of rope. Wait until next round.")
			return PLUGIN_HANDLED
		}else{
			if( (get_cvar_num("amx_rep_rcount") == 1) && (ropes_round_cvar-RopeCount[id] < 10) ){
				if(ropes_round_cvar - RopeCount[id] == 0)
					client_print(id,print_chat, "[AMXX] That was your last rope for this round.")
				else
					client_print(id,print_chat, "[AMXX] You have %d ropes left, use them wisely.",ropes_round_cvar-RopeCount[id])
			}
		}
		attach(id)
	}
	else if (get_cvar_num("sv_ninjarope") && hooked[id])
	{
		release(id)
	}
	return PLUGIN_HANDLED
}

public attach(id){
	new parm[1], user_origin[3]
	parm[0] = id
	hooked[id] = true
	get_user_origin(id, user_origin)
	get_user_origin(id, hooklocation[id], 3)
	hooklength[id] = get_distance(hooklocation[id],user_origin)
	global_gravity = get_cvar_num("sv_gravity")
	set_user_gravity(id,0.001)
	beamentpoint(id)
	emit_sound(id, CHAN_STATIC, "weapons/xbow_hit2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	set_task(DELTA_T, "hooktask", 200+id, parm, 1, "b")
	set_task(HOLD_T, "let_go",77545+id,parm, 1)
	server_cmd("ropemissile_chk %d 1",id)
}

public let_go(parm[]){
	release(parm[0])
	return PLUGIN_CONTINUE
}


public release(id){
	hooked[id] = false
	killbeam(id)
	set_user_gravity(id)
	remove_task(200+id)
	remove_task(77545+id)
	remove_task(77578+id)
	server_cmd("ropemissile_chk %d 0",id)
}

public beamentpoint(id)
{
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte( TE_BEAMENTPOINT )
	write_short( id )
	write_coord( hooklocation[id][0] )
	write_coord( hooklocation[id][1] )
	write_coord( hooklocation[id][2] )
	if(get_cvar_num("amx_ropetype") == 1) {
		write_short( s_rope )	// sprite index
		write_byte( 0 )		// start frame
		write_byte( 0 )		// framerate
		write_byte( BEAMLIFE )	// life
		write_byte( 2 )	// width
		write_byte( 1 )		// noise
		write_byte( 250 )	// r, g, b
		write_byte( 250 )	// r, g, b
		write_byte( 250 )	// r, g, b
		write_byte( 250 )	// brightness
	}
	else {
		write_short( beam )	// sprite index
		write_byte( 0 )		// start frame
		write_byte( 0 )		// framerate
		write_byte( BEAMLIFE )	// life
		write_byte( 10 )	// width
		write_byte( 2 )		// noise
		if (get_user_team(id) == 1)	// Terrorist
		{
			write_byte( 255 )	// r, g, b
			write_byte( 0 )		// r, g, b
			write_byte( 0 )		// r, g, b
		}
		else				// Counter-Terrorist
		{
			write_byte( 0 )		// r, g, b
			write_byte( 0 )		// r, g, b
			write_byte( 255 )	// r, g, b
		}
		write_byte( 150 )		// brightness
	}
	write_byte( 0 )		// speed
	message_end( )
	beamcreated[id] = get_gametime()
}

public killbeam(id)
{
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte( TE_KILLBEAM )
	write_short( id )
	message_end()
}

public new_round(id) {
	if (hooked[id]) release(id)
}

public round_start() {
	if (get_cvar_num("amx_rope_spawndelay") && !round_delay) {
		round_delay = 1
		set_task(15.0,"roundstart_delay")
	}
	roundfreeze = false
	mapbounds_killer()
}
public round_end() {
	roundfreeze = true
	for (new i=1; i <= get_maxplayers(); i++) {
		RopeCount[i] = 0
		IsVip[i] = 0
	}
}

public amx_hc(id,level,cid){
	if (!cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED

	new command[60]
	new variable[6]
	new name[32]
	get_user_name(id,name,31)
	read_argv(0,command,59)
	read_argv(1,variable,5)

	if(get_cvar_num("sv_ninjarope") == 1){
		new maxplayers = get_maxplayers()+1
		for (new i=1; i<=maxplayers; i++) {
			RopeCount[i] = 0
			if (hooked[i]){
				release(i)
			}
		}
		set_cvar_string("sv_ninjarope","0")
		client_print(id,print_console,"[AMXX] %s has been set turned OFF",command)
		server_print("[AMXX] %s has been set turned OFF",command)
		switch(get_cvar_num("amx_show_activity"))	{
			case 2:	client_print(0,print_chat,"ADMIN %s: Executed %s OFF",name,command)
			case 1:	client_print(0,print_chat,"ADMIN: Executed %s OFF",command)
		}
		mapbounds_killer()
	}
	else {
		set_cvar_string("sv_ninjarope","1")
		client_print(id,print_console,"[AMXX] %s has been set turned ON.",command)
		server_print("[AMXX] %s has been set turned ON.",command)
		switch(get_cvar_num("amx_show_activity"))	{
			case 2:	client_print(0,print_chat,"ADMIN %s: Executed %s ON",name,command)
			case 1:	client_print(0,print_chat,"ADMIN: Executed %s ON",command)
		}
		mapbounds_killer()
	}
	return PLUGIN_HANDLED
}

public admin_hook_count(id,level,cid){
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED
	new arg[8]
	read_argv(1,arg,7)
	if ((str_to_num(arg) > 10000) || (str_to_num(arg) < 1)){
		console_print(id,"[AMXX] Invalid parameter. Must be a number between 1 and 10000")
		return PLUGIN_HANDLED
	}
	new name[32]
	get_user_name(id,name,31)
	console_print(id,"[AMXX] Rope count per round is now %s",arg)
	switch(get_cvar_num("amx_show_activity"))	{
		case 2:	client_print(0,print_chat,"ADMIN %s: Executed amx_rope_count %s",name,arg)
		case 1:	client_print(0,print_chat,"ADMIN: Executed amx_rope_count %s",arg)
	}
	set_cvar_string("amx_ropes_round",arg)
	return PLUGIN_HANDLED
}

public HandleSay(id) {
	new Speech[192]
	read_args(Speech,192)
	remove_quotes(Speech)

	if( (containi(Speech, "vote") == -1) && ((containi(Speech, "rope") != -1) || (containi(Speech, "hook") != -1) || (containi(Speech, "spider") != -1) || (containi(Speech, "swing") != -1) || (containi(Speech, "grap") != -1))) {
		if(get_cvar_num("sv_ninjarope") == 1)
			client_print(id,print_chat, "[AMXX] Ninja Rope is enabled - For help say /rope")
		else
			client_print(id,print_chat, "[AMXX] Ninja Rope is disabled")

	}

	return PLUGIN_CONTINUE
}

public roundstart_delay(){
	round_delay = 0
}

public client_connect(id){
	RpDelay[id] = 0.0
	RopeCount[id] = 0
	hooked[id] = false
}

public client_disconnect(id){
	RpDelay[id] = 0.0
	RopeCount[id] = 0
	hooked[id] = false

}

public mapbounds_killer(){
	if(get_cvar_num("amx_rb_pl_kill") == 0)
		return PLUGIN_CONTINUE

	if (!mapbounds_checked) {
		new nump = get_pluginsnum()
		new filename[64],temp[5]
		for(new i=0;i<nump;++i){
			get_plugin(i,filename,63,temp,4,temp,4,temp,4,temp,4)
		
			if (equali(filename,"amx_ejl_outofbounds.amx"))
				ob_pl1 = 1
			else if (equali(filename,"out_of_bounds.amx"))
				ob_pl2 = 1
		}
		mapbounds_checked = true
	}
	
	if (get_cvar_num("sv_hook") == 1) {
		if(ob_pl1 == 1)
			pause("ac","amx_ejl_outofbounds.amx")
		if(ob_pl2 == 1)
			pause("ac","out_of_bounds.amx")
	}
	else {
		if(ob_pl1 == 1)
			unpause("ac","amx_ejl_outofbounds.amx")
		if(ob_pl2 == 1)
			unpause("ac","out_of_bounds.amx")		
	}

	return PLUGIN_CONTINUE
}

public vip_spawn(id){
	if(get_cvar_num("amx_rope_no_vip") == 1){
		new inum
		new players[32]
		get_players(players, inum ,"c")
		if(inum > 1) {
			IsVip[id] = 1
		}
	}
	return PLUGIN_CONTINUE
}

public rope_motd(id){

	new len = 1300
	new buffer[1301]
	new n = 0

#if !defined NO_STEAM
	n += copy( buffer[n],len-n,"<html><head><style type=^"text/css^">pre{color:#FFB000;}body{background:#000000;margin-left:8px;margin-top:0px;}</style></head><body><pre>")
#endif


	n += copy( buffer[n],len-n,"To use your rope have to bind a key to: +rope^n^n")

	n += copy( buffer[n],len-n,"In order to bind a key you must open your console and use the bind command: ^n^n")
	n += copy( buffer[n],len-n,"bind ^"key^" ^"command^" ^n^n")

	n += copy( buffer[n],len-n,"In this case the command is ^"+rope^".  Here are some examples:^n^n")
	n += copy( buffer[n],len-n,"	bind f +rope		bind MOUSE3 +rope^n^n")

	n += copy( buffer[n],len-n,"Now whenever you press the that button, it launches your rope.^n")
	n += copy( buffer[n],len-n,"Make sure to hold the key down as long as you want to be on the rope.^n")
	n += copy( buffer[n],len-n,"Release the key when you want to get off of the rope.^n")
	n += copy( buffer[n],len-n,"To make the rope shorter, press your jump button while using the rope.^n")
	n += copy( buffer[n],len-n,"To make the rope longer, press duck while on the rope.^n^n")

	n += copy( buffer[n],len-n,"New Command: rope_toggle - has the same effect as +rope, except that you^n")
	n += copy( buffer[n],len-n,"	press it once to fire it and once again to release.^n^n")

	n += copy( buffer[n],len-n,"Roping has to be enabled for you to use the rope.^n")
	n += copy( buffer[n],len-n,"Under normal circumstances when rope is enabled, vip's in CS cannot use the rope.^n")
	n += copy( buffer[n],len-n,"Also the rope may not be used for the first 15 seconds of a round in CS.^n")

#if !defined NO_STEAM
	n += copy( buffer[n],len-n,"</pre></body></html>")
#endif

	show_motd(id,buffer,"Ninja Rope Help")
	return PLUGIN_CONTINUE
}

public plugin_precache() {
	beam = precache_model("sprites/zbeam4.spr")
	s_rope = precache_model("sprites/rope.spr")
	precache_sound("weapons/xbow_hit2.wav")
}

public plugin_init() {
	register_plugin("Ninja Rope","1.1.1","EJL-SpaceDude/JTP10181")
	register_concmd("amx_rope","amx_hc",ADMIN_LEVEL_A,": toggles rope on and off")
	register_concmd("amx_rope_count","admin_hook_count",ADMIN_LEVEL_A,": <# of ropes allowed to each player per round>")
	register_clcmd("say","HandleSay")
	register_clcmd("say /rope","rope_motd")

	register_cvar("amx_rope_spawndelay","0")
	register_cvar("amx_rope_no_vip","1")
	register_cvar("amx_ropes_round","100")
	register_cvar("amx_rep_rcount","1")
	register_cvar("amx_ropetype","1")
	register_event("Battery","vip_spawn","b","1=200")

	register_cvar("sv_ninjarope","1",FCVAR_SERVER)
	register_clcmd("rope_toggle", "rope_toggle")
	register_clcmd("+rope", "hook_on")
	register_clcmd("-rope", "hook_off")
	register_event("ResetHUD", "new_round", "b")
	
	register_logevent("round_start", 2, "1=Round_Start") 
	register_logevent("round_end", 2, "1=Round_End")

	register_cvar("amx_rb_pl_kill","1")
	set_task(4.0,"mapbounds_killer")
}

public plugin_modules()
{
	require_module("fun")
	require_module("engine")
}
